//********************************************************************
//  LeapYear2.java       Author: Lewis/Loftus
//
//  Solution to Programming Project 5.2 (5E, p. 285)
//********************************************************************

import java.util.Scanner;

public class LeapYear2
{
   //-----------------------------------------------------------------
   //  Reads an integer value representing a year. Determines if the
   //  year is a leap year. Processes multiple years.
   //-----------------------------------------------------------------
   public static void main (String[] args)
   {
      int year;
      boolean leap = false;
	  Scanner scan = new Scanner(System.in);

      do
      {
         System.out.print("\nEnter a year (0 to quit): ");
         year = scan.nextInt();

         if (year != 0)
         {
            if (year < 1582)
               System.out.println("ERROR year not valid in the Gregorian calendar");
            else
            {
               if (year % 4 == 0) // divisible by 4
               {
                  leap = true;
                  if ((year % 100 == 0) && (year % 400 != 0))
                  {
                     leap = false;
                  }
               }
               if (leap)
                  System.out.println(year + " is a leap year");
               else
                  System.out.println(year + " is not a leap year");
            }
         }
         leap = false;
      } while (year != 0);
   }
}